﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ITA_580
{
    public partial class Form1
    {
        private void ShowWatchDogTime()
        {
            byte res;
            UInt32 dtime;
            UInt32 etime;

            //get delay time
            dtime = 0;
            res = AecWdtGetDelayTime(gPtrAecInit, ref dtime);
            if (res != 0)
            {
                MessageBox.Show("Set WatchDog Delay Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            else
            {
                dtime /= 1000;  //unit second
                textBox1.Text = dtime.ToString();
            }

            //get event time
            etime = 0;
            if (radioButton28.Checked == true)  //cold reset
            {
                res = AecWdtGetPowerBtnEventTime(gPtrAecInit, ref etime);
                if (res != 0)
                {
                    MessageBox.Show("Set WatchDog Cold Reset Event Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                {
                    etime /= 1000;  //unit second
                    textBox2.Text = etime.ToString();
                }
            }
            else if (radioButton27.Checked == true)  //warm reset
            {
                res = AecWdtGetResetEventTime(gPtrAecInit, ref etime);
                if (res != 0)
                {
                    MessageBox.Show("Set WatchDog Warm Reset Event Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                else
                {
                    etime /= 1000;  //unit second
                    textBox2.Text = etime.ToString();
                }
            }
        }

        private void SetWatchDogStart()
        {
            byte res;
            UInt32 dtime;
            UInt32 etime;

            //set delay time
            dtime = Convert.ToUInt32(textBox1.Text) * 1000; //unit ms
            res = AecWdtSetDelayTime(gPtrAecInit, dtime);
            if (res != 0)
            {
                MessageBox.Show("Set WatchDog Delay Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            //set event time
            etime = Convert.ToUInt32(textBox2.Text) * 1000; //unti ms
            if (radioButton28.Checked == true)  //cold reset
            {
                res = AecWdtSetPowerBtnEventTime(gPtrAecInit, etime);
                if (res != 0)
                {
                    MessageBox.Show("Set WatchDog Cold Reset Event Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
            else if (radioButton27.Checked == true)  //warm reset
            {
                res = AecWdtSetResetEventTime(gPtrAecInit, etime);
                if (res != 0)
                {
                    MessageBox.Show("Set WatchDog Warm Reset Event Time Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }

            //start
            res = AecWdtSendCommandStart(gPtrAecInit);
            if (res != 0)
            {
                MessageBox.Show("Set WatchDog Start Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void SetWatchDogStop()
        {
            byte res;

            res = AecWdtSendCommandStop(gPtrAecInit);
            if (res != 0)
            {
                MessageBox.Show("Set WatchDog Stop Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}
